<?php
  include '../dbConn.php';
  include 'checkLogin.php';
  include 'menus.php';

  $user_avatar = $loggedUserData['user_avatar'];
  $customerToken = $_SESSION["customerToken"];
?>

<!doctype html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang=""> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8" lang=""> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9" lang=""> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" lang=""> <!--<![endif]-->
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>ASRL Portal</title>
    <meta name="description" content="Ela Admin - HTML5 Admin Template">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="apple-touch-icon" href="https://marketappz.com/asrl/admin/images/favicon.png">
    <link rel="shortcut icon" href="https://marketappz.com/asrl/admin/images/favicon.png">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/normalize.css@8.0.0/normalize.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/font-awesome@4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/lykmapipo/themify-icons@0.1.2/css/themify-icons.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/pixeden-stroke-7-icon@1.2.3/pe-icon-7-stroke/dist/pe-icon-7-stroke.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.2.0/css/flag-icon.min.css">
    <link rel="stylesheet" href="assets/css/cs-skin-elastic.css">
    <link rel="stylesheet" href="assets/css/lib/datatable/dataTables.bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/custom.css">

    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,600,700,800' rel='stylesheet' type='text/css'>

    <!-- <script type="text/javascript" src="https://cdn.jsdelivr.net/html5shiv/3.7.3/html5shiv.min.js"></script> -->

</head>
<body>
    <!-- Left Panel -->

    <aside id="left-panel" class="left-panel">
        <nav class="navbar navbar-expand-sm navbar-default">

            <div id="main-menu" class="main-menu collapse navbar-collapse">
                <?php displayMainMenu(); ?>
            </div><!-- /.navbar-collapse -->
        </nav>
    </aside><!-- /#left

    <!-- Left Panel -->

    <!-- Right Panel -->

    <div id="right-panel" class="right-panel">

        <!-- Header-->
        <header id="header" class="header">
            <div class="top-left">
                <div class="navbar-header">
                    <a class="navbar-brand" href="./"><img src="images/logo.png" alt="Logo"></a>
                    <a class="navbar-brand hidden" href="./"><img src="images/logo2.png" alt="Logo"></a>
                    <a id="menuToggle" class="menutoggle"><i class="fa fa-bars"></i></a>
                </div>
            </div>
            <div class="top-right">
                <div class="header-menu">
                    <div class="header-left">
                    </div>

                    <div class="user-area dropdown float-right">
                        <a href="#" class="dropdown-toggle active" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <img class="user-avatar rounded-circle" src="<?php echo $user_avatar; ?>" alt="User Avatar">
                        </a>

                        <?php displayProfileMenu(); ?>

                    </div>
                </div>
            </div>
        </header><!-- /header -->
        <!-- Header-->


        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                  <div class="col-md-12">
                      <div class="card">
                          <div class="card-header">
                              <strong class="card-title">Account Information</strong>
                          </div>
                          <div class="card-body">
                            <form method="POST" action="saveAccountInfo.php?customerToken=<?php echo $loggedUserData['customerToken']; ?>" enctype="multipart/form-data">
                                <div class="row justify-content-center" style="margin:100px 0 0 0;">
                                  <div class="col-md-6">
                                    <div class="form-group mt-full-width">
                                      <div class="col-md-12 noPadding">
                                        <div class="row justify-content-center">
                                          <div class="col-md-6">
                                            <img id="avatarPreview" src="<?php echo $user_avatar; ?>" style="padding-bottom: 40px;" alt="<?php echo $loggedUserData['username']; ?> Avatar">
                                          </div>
                                        </div>
                                        <div class="col-md-12 noPadding">
                                          <input type="file" name="avatar" accept="image/*">
                                        </div>
                                      </div>
                                    </div>
                                    <div class="form-group mt-full-width">
                                      <label class=" form-control-label">Username</label>
                                      <input disabled type="text" name="username" placeholder="Username" value="<?php echo $loggedUserData['username']; ?>">
                                    </div>
                                    <div class="form-group mt-full-width">
                                      <label class=" form-control-label">First name</label>
                                      <input type="text" name="user_data[first_name]" placeholder="First Name" value="<?php echo $loggedUserData['user_data']['first_name']; ?>">
                                    </div>
                                    <div class="form-group mt-full-width">
                                      <label class=" form-control-label">Last name</label>
                                      <input type="text" name="user_data[last_name]" placeholder="Last Name" value="<?php echo $loggedUserData['user_data']['last_name']; ?>">
                                    </div>
                                    <div class="form-group mt-full-width">
                                      <label class=" form-control-label">Email</label>
                                      <input type="text" name="user_data[email]" placeholder="Email" value="<?php echo $loggedUserData['user_data']['email']; ?>">
                                    </div>

                                    <div class="form-group mt-full-width">
                                      <label class=" form-control-label">Vest Size</label>
                                      <select class="form-control" name="user_data[vest_size]" value="">
                                        <option value="">Select Vest Size</option>
                                        <option value="xs">Extra Small</option>
                                        <option value="s">Small</option>
                                        <option value="m">Medium</option>
                                        <option value="l">Large</option>
                                      </select>
                                    </div>

                                    <div class="form-group mt-full-width">
                                      <?php
                                      if ($_GET['status'] == "success") {
                                        echo '<p style="color:green;">Account details have been successful updated.</p>';
                                      }
                                      ?>
                                      <button type="submit" class="btn btn-outline-primary">Save</button>
                                    </div>
                                  </div>
                                </div>
                            </form>

                            <div class="row justify-content-center" style="margin: 50px 0 50px 0;">
                              <div class="col-md-12">
                                <h3 style="text-align:center;margin-bottom:40px;">My Teams</h3>
                              </div>
                              <div class="col-md-6">
                                <table class="table table-striped">
                                  <thead>
                                    <tr>
                                      <th scope="col">Team Name</th>
                                      <th scope="col">Competitions</th>
                                    </tr>
                                  </thead>
                                  <tbody>
                                    <?php
                                      $searchCustomer = mysqli_query($db,"SELECT * FROM `membership_linking` WHERE `user_token`='$customerToken'");
                                      while ($searchCustomerRow = mysqli_fetch_array($searchCustomer)) {
                                        $teamToken = $searchCustomerRow['team_token'];
                                        $getTeam = mysqli_query($db,"SELECT * FROM `team` WHERE `token`='$teamToken'");
                                        $teamRow = mysqli_fetch_array($getTeam);
                                        echo '
                                        <tr>
                                          <td>'.$teamRow['teamName'].'</td>
                                          <td><a href="https://asrl.marketappz.com/admin/listCompetitions.php?userToken=twehgrg&search='.$teamRow['token'].'">View Comps</td>
                                        </tr>';
                                      }
                                    ?>
                                  </tbody>
                                </table>
                              </div>
                            </div>
                          </div>
                      </div>
                  </div>
                </div>
            </div><!-- .animated -->
        </div><!-- .content -->


        <div class="clearfix"></div>

        <footer class="site-footer">
            <div class="footer-inner bg-white">
                <div class="row">
                    <div class="col-sm-6">
                        Copyright &copy; <?php echo date("Y"); ?> ASRL
                    </div>
                </div>
            </div>
        </footer>

    </div><!-- /#right-panel -->

    <!-- Right Panel -->

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/jquery@2.2.4/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.4/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-match-height@0.7.2/dist/jquery.matchHeight.min.js"></script>
    <script src="assets/js/main.js"></script>


    <script src="assets/js/lib/data-table/datatables.min.js"></script>
    <script src="assets/js/lib/data-table/dataTables.bootstrap.min.js"></script>
    <script src="assets/js/lib/data-table/dataTables.buttons.min.js"></script>
    <script src="assets/js/lib/data-table/buttons.bootstrap.min.js"></script>
    <script src="assets/js/lib/data-table/jszip.min.js"></script>
    <script src="assets/js/lib/data-table/vfs_fonts.js"></script>
    <script src="assets/js/lib/data-table/buttons.html5.min.js"></script>
    <script src="assets/js/lib/data-table/buttons.print.min.js"></script>
    <script src="assets/js/lib/data-table/buttons.colVis.min.js"></script>
    <script src="assets/js/init/datatables-init.js"></script>


    <script type="text/javascript">
      $(document).ready(function() {
        $('#bootstrap-data-table-export').DataTable();

        $("[name='user_data[vest_size]']").val("<?php echo $loggedUserData['user_data']['vest_size']; ?>");
      });


      function readURL(input) {
        if (input.files && input.files[0]) {
          var reader = new FileReader();

          reader.onload = function(e) {
            $('#avatarPreview').attr('src', e.target.result);
          }

          reader.readAsDataURL(input.files[0]);
        }
      }

      $("[name='avatar']").change(function() {
        readURL(this);
      });
  </script>


</body>
</html>
